﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Web.Security.AntiXss;
using VeteransAffairs.Registries.Business.Utilities;

public partial class LabResults : BasePage
{
    private int OrderType;
    protected void Page_Load(object sender, EventArgs e)
    {
        //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.
        int orderType = GetOrderType();
        if (!IsPostBack)
        {
            BreadCrumbLabel.Text = BreadCrumbLabel.Text + Enum.GetName(typeof(WorkflowCaseActivityStatus), orderType).AddSpacesToCamelCase();

            //For New and InProcess statuses, Accepted date does not have a value
            if (orderType == 6 || OrderType == 1)
                GridViewLabResults.Columns[3].Visible = false;

            //For InProcess and Accepted Status display "Lab Report Date"
            if (orderType == Convert.ToInt16(WorkflowCaseActivityStatus.InProcess)
                    ||
                OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted))
            {
                GridViewLabResults.Columns[1].Visible = true;
            }

            HiddenFieldClearFlag.Value = "0";
        }

        if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.New))
        {
            ObjectDataSourceGridViewLabResults.SelectMethod = "GetNewLabResults";
        }
        else if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.InProcess))
        {
            ObjectDataSourceGridViewLabResults.SelectMethod = "GetInProcessLabResults";
        }
        else if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted))
        {
            ObjectDataSourceGridViewLabResults.SelectMethod = "GetCompletedLabResults";
        }
        else if (OrderType == Convert.ToInt16(WorkflowCaseActivityStatus.Voided))
        {
            ObjectDataSourceGridViewLabResults.SelectMethod = "GetVoidedLabResults";
        }
        ObjectDataSourceGridViewLabResults.SelectCountMethod = "GetNewLabResultsCount";
        GridViewLabResults.DataSourceID = "ObjectDataSourceGridViewLabResults";
        //GridViewLabResults.DataBind();
    }
    protected override void OnInitComplete(EventArgs e)
    {
        base.OnInitComplete(e);
    }

    protected void ObjectDataSourceGridViewLabResults_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        //if (((IEnumerable<LabResult>)e.ReturnValue).Count() == 0)
        if (e.ReturnValue.GetType() != null && !e.ReturnValue.GetType().IsValueType)
        if (e.ReturnValue == null || ((IEnumerable<LabResultsManager.LabResult>)e.ReturnValue).Count()== 0)
            GridViewLabResults.EmptyDataText = "No records found for the " + Enum.GetName(typeof(WorkflowCaseActivityStatus), GetOrderType()).AddSpacesToCamelCase() + " lab results.";
    }

    private int GetOrderType()
    {
        if (!IsPostBack)
        {
            OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
            ViewState["OrderType"] = OrderType;
        }
        else //For paging
            OrderType = Convert.ToInt16(ViewState["OrderType"]);
        return OrderType;
    }

    protected void SelectActivity(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewLabResults.SelectedIndex = index;
            Int32 ActivityId = Convert.ToInt32(GridViewLabResults.SelectedDataKey.Values[0]);
            WorkflowManager Wfm = new WorkflowManager();
            int WfType = Wfm.GetWorkflowType(ActivityId);
            if (WfType == Convert.ToInt16(WorkFlowTypes.Biomonitoring))
                Response.Redirect("LabResultDetails.aspx?ActivityId={0}", ActivityId);
            if (WfType == Convert.ToInt16(WorkFlowTypes.FragmentAnalysis))
            {
                //empty session from previous contents
                if (SessionItemValue.Get(Session["LabRptDate"]) != null)
                    Session.Remove("LabRptDate");

                if (SessionItemValue.Get(Session["Accession"]) != null)
                    Session.Remove("Accession");

                if (SessionItemValue.Get(Session["LabId"]) != null)
                    Session.Remove("LabId");

                if (SessionItemValue.Get(Session["LabCode"]) != null)
                    Session.Remove("LabCode");

                if (SessionItemValue.Get(Session["EventDate"]) != null)
                    Session.Remove("EventDate");

                Response.Redirect("FragLabResultDetails.aspx?ActivityId={0}", ActivityId);
            }
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewLabResults.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabResults";
    }

    public override string AppObjectCode()
    {
        return "LabResults";
    }
}